﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Handel" %>
<%@ Import Namespace="Soneta.Magazyny" %>
<%@ Import Namespace="Soneta.Towary" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="System" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
    <title>Obroty kontrahentów i towarów</title>
    <meta content="C#" name="CODE_LANGUAGE">
    <meta content="JavaScript" name="vs_defaultClientScript">
    <meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">

    <script runat="server">

        public class ParametryContext : ContextBase {
            public ParametryContext(Context cx)
                : base(cx) {
            }

            bool obrotyZerowe = true;

            public bool ObrotyZerowe {
                get { return obrotyZerowe; }
                set { obrotyZerowe = value; }
            }

            bool pokazujStorna = false;

            public bool PokazujStorna {
                get { return pokazujStorna; }
                set { pokazujStorna = value; }
            }
        }

        ParametryContext parametry;

        [Context]
        public ParametryContext Parametry {
            get { return parametry; }
            set { parametry = value; }
        }

        void Grid_ItemsGet(object sender, ItemsGetEventArgs args) {
            if (args.Deep == 1) {

                KeyValuePair<Kontrahent, List<Total>> kvp = (KeyValuePair<Kontrahent, List<Total>>)args.Row;
                Kontrahent kontrahent = kvp.Key;
                
                if (kontrahent != null) {
                    string kontrahentHtml = HttpUtility.HtmlEncode( kontrahent.ToString() );
                    Grid.GroupLine = string.Format("Kontrahent: {0}", kontrahentHtml);
                }
                else
                    Grid.GroupLine = "Kontrahent: nieokreślony";
                    
                args.Enumerable = kvp.Value;
            }
        }

        int nr = 0;

        protected void dc_ContextLoad(object sender, EventArgs e) {
            Soneta.Magazyny.ObrotyParams pars = (Soneta.Magazyny.ObrotyParams)dc[typeof(Soneta.Magazyny.ObrotyParams)];
            if (pars.Kontrahent != null)
                ReportHeader.Title += String.Format( "|Kontrahent: <strong>{0}</strong>", pars.Kontrahent );

            Row[] rows = (Row[])dc[typeof(Row[])];

            IDictionary<Kontrahent, List<Total>> dict = new Dictionary<Kontrahent, List<Total>>();
            Set<Obrot> przetworzoneObroty = new Set<Obrot>();
            
            foreach (Towar t in rows) {
                if (!Parametry.ObrotyZerowe && t.Obroty.IsEmpty) 
                    continue;
                
                foreach (PozycjaDokHandlowego p in t.Pozycje) {
                    if( p.Dokument.Definicja.KierunekMagazynu != KierunekPartii.Rozchód )
                        continue;

                    if( p.Data < pars.OkresDat.From || p.Data > pars.OkresDat.To )
                        continue;

                    if(pars.Magazyn != null && p.Dokument.Magazyn != pars.Magazyn)
                            continue;

                    if (p.Dokument.Anulowany) continue;
                    if (p.Dokument.Definicja.DuplikatWartosci) continue;
                    if (p.Dokument.Kontrahent == null) continue;
                    if (pars.Kontrahent != null && pars.Kontrahent != p.Dokument.Kontrahent) continue;
                    
                    if( !dict.ContainsKey( p.Dokument.Kontrahent ) )
                        dict.Add( p.Dokument.Kontrahent, new List<Total>() );

                    bool znalezione = false;
                    foreach( Total total in dict[p.Dokument.Kontrahent] ) {
                        if( total.Towar == p.Towar ) {
                            znalezione = true;
                            break;
                        }
                    }

                    if( !znalezione )
                        dict[p.Dokument.Kontrahent].Add( new Total( p.Towar ) );
                    
                    foreach( Obrot o in p.Dokument.Obroty ) {
                        foreach( Total total in dict[p.Dokument.Kontrahent] ) {                                                        
                            if( o.Towar == total.Towar ) {
                                if( przetworzoneObroty.Contains( o ) )
                                    continue;
                                
                                total.Add( o );
                                przetworzoneObroty.Add( o );
                            }
                        }
                    }
                }
            }

            Grid.DataSource = dict;
        }

        class Total {
            readonly Towar towar;
            
            double ilość = 0;
            decimal przychód = 0m;
            decimal rozchód = 0m;
            decimal marża = 0m;
            decimal marżaJednostkowa = 0m;

            public Total( Towar t ) {
                towar = t;
            }
            
            public void Add( Obrot o ) {
                ilość += o.Ilosc.Value;
                przychód += o.Przychod.Wartosc;
                rozchód += o.Rozchod.Wartosc;
                marża += o.Marża;
            }

            public Towar Towar {
                get {
                    return towar;
                }
            }

            public double Ilość {
                get {
                    return ilość;
                }
            }

            public decimal Przychód {
                get {
                    return przychód;
                }
            }
            
            public decimal Rozchód {
                get {
                    return rozchód;
                }
            }

            public decimal Marża {
                get {
                    return marża;
                }
            }
        }
    </script>

</head>
<body>
    <form method="post" runat="server" action="#">
        <ea:DataContext ID="dc" runat="server" OnContextLoad="dc_ContextLoad"></ea:DataContext>
        <eb:ReportHeader ID="ReportHeader" Title="Obroty kontrahentów i towarów|Magazyn: <STRONG>{0},</STRONG> Okres: <STRONG>{1}</STRONG>"
            runat="server" DataMember0="ObrotyParams.Magazyn" DataMember1="ObrotyParams.OkresDat">
        </eb:ReportHeader>
        <ea:Grid ID="Grid" runat="server" RowTypeName="System.Collections.DictionaryEntry, System.Collections"
            OnItemsGet="Grid_ItemsGet" ShowGroupSum="True">
            <Columns>
                <ea:GridColumn runat="server" Width="4" Align="Right" Caption="Lp." ID="lp" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" DataMember="Towar" Total="Info" Caption="Towar"
                    EncodeHTML="True">
                </ea:GridColumn>
               <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Ilość" Caption="Ilość"
                    EncodeHTML="True">
                </ea:GridColumn>
               <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Przychód"
                    Total="Sum" Caption="Przych&#243;d~Wartość" Format="{0:n}" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Rozchód"
                    Total="Sum" Caption="Rozch&#243;d~Wartość" Format="{0:n}" EncodeHTML="True">
                </ea:GridColumn>
                <ea:GridColumn runat="server" Width="10" Align="Right" DataMember="Marża" Total="Sum"
                    Caption="Marża~Wartość" Format="{0:n}" EncodeHTML="True">
                </ea:GridColumn>
            </Columns>
        </ea:Grid>
        <eb:ReportFooter ID="ReportFooter" runat="server" PrintDate="true" PrintTime="true">
        </eb:ReportFooter>
    </form>
</body>
</html>

